//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3
import QtQuick.Window 2.2

import wesual.data.Core 1.0

Item {
    property Tag   tag
    property color tintColor : "white"

    opacity : tagImage.status === Image.Ready ? 1 : 0

    Behavior on opacity {
        NumberAnimation { duration : 150 }
    }

    Image {
        id : tagImage

        sourceSize {
            width : parent.width * Screen.devicePixelRatio
            height : parent.height * Screen.devicePixelRatio
        }

        anchors.fill : parent
        source : tag ? tag.icon : ""
        asynchronous : true
        visible : false
        mipmap : true
    }

    ShaderEffect {
        anchors.fill : parent

        property var   src  : tagImage
        property color tint : parent.tintColor

        vertexShader: "
            uniform highp mat4 qt_Matrix;
            attribute highp vec4 qt_Vertex;
            attribute highp vec2 qt_MultiTexCoord0;
            varying highp vec2 coord;
            void main() {
                coord = qt_MultiTexCoord0;
                gl_Position = qt_Matrix * qt_Vertex;
            }"
        fragmentShader: "
            varying highp vec2 coord;
            uniform sampler2D src;
            uniform lowp vec4  tint;
            uniform lowp float qt_Opacity;
            void main() {
               gl_FragColor = tint * texture2D(src, coord).a * qt_Opacity;
            }"
    }
}
